/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.table;

import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.ui.bonsai.table.ImageWithHyperlinkCell;
import com.ibm.hwmca.ui.bonsai.table.NameTableCellBean;
import com.ibm.psw.wcl.components.table.WTable;
import com.ibm.psw.wcl.core.RenderingContext;
import com.ibm.psw.wcl.core.cell.AWCell;
import com.ibm.psw.wcl.core.cell.CellInfo;
import com.ibm.psw.wcl.core.markup.WHyperlink;
import com.ibm.psw.wcl.core.markup.WImage;
import com.ibm.psw.wcl.core.renderer.RendererException;
import com.ibm.psw.wcl.core.renderer.output.IOutput;
import com.ibm.psw.wcl.core.skin.AStyleInfo;
import com.ibm.psw.wcl.renderers.cell.html.HTMLDefaultCellRenderer;
import com.ibm.psw.wcl.skins.base.BaseHyperlinkStyleInfo;

public class TasksNameCellRenderer
extends HTMLDefaultCellRenderer {
    private static final String TRACEMASK_T = "XBUITNRT";
    private static final String TRACEMASK_F = "XBUITNRF";
    private static final String TRACEMASK_D = "XBUITNRD";

    public IOutput renderCell(RenderingContext rc, AWCell cell, CellInfo info) throws RendererException {
        if (cell instanceof ImageWithHyperlinkCell) {
            return this.prepareCell(rc, (ImageWithHyperlinkCell)cell, info);
        }
        return super.renderCell(rc, cell, info);
    }

    public IOutput prepareCell(RenderingContext rc, ImageWithHyperlinkCell cell, CellInfo cellInfo) throws RendererException {
        Trace.trace(TRACEMASK_D, "-> SystemTableCellRenderer.prepareCell()");
        NameTableCellBean cellBean = (NameTableCellBean)cellInfo.getValue();
        if (cellBean == null) {
            return cell.getOutput(rc);
        }
        cell.getHyperlink().setStyleInfo(null);
        AStyleInfo hyperlinkStyle = cell.getHyperlink().getStyleInfo(rc.getSkin());
        if (hyperlinkStyle == null) {
            hyperlinkStyle = new BaseHyperlinkStyleInfo();
            cell.getHyperlink().setStyleInfo(hyperlinkStyle);
        }
        cell.setText(cellBean.getText());
        String imageUrl = cellBean.getImageUrl();
        if (imageUrl != null) {
            WImage anImage = cell.getImage();
            anImage.setURL(imageUrl);
            cell.setImage(anImage);
        }
        String linkUrl = cellBean.getUrl();
        WHyperlink link = cell.getHyperlink();
        if (linkUrl != null) {
            link.setURL(linkUrl);
            link.setTarget(cellBean.getUrlTarget());
            link.setEnabled(true);
        } else {
            hyperlinkStyle.setStyleValue("lnk1", "color", (Object)"#000000");
            link.setEnabled(false);
        }
        hyperlinkStyle.setStyleValue("lnk1", "font-size", (Object)"smaller");
        cell.setStyleInfo(hyperlinkStyle);
        return cell.getOutput(rc);
    }

    private boolean isSingleRowSelected(CellInfo cellInfo) {
        boolean selected = ((WTable)cellInfo.getOwnerComponent()).getModel().getSelectedModelRowCount() == 1;
        return true;
    }
}

